﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
' 此类被标记为可序列化且它实现了
' 允许自定义序列化的 ISerializable。ISerializable 要求
' 实现 GetObjectData 方法和将在反序列化时调用的
' 另一个构造函数。
Imports System.Runtime.Serialization

' 此属性使类可序列化。
<Serializable()> Public Class CustomSerializableClass
    Implements ISerializable

    ' 因为此示例中使用自定义序列化，所以 
    ' 不强制 NonSerialized 属性。而是由类的编写器
    ' 根据下面的 GetObjectData 方法确定序列化哪些内容以及不序列化哪些内容。
    ' 注意，在此类中，尽管 NonSerializedVariable 被标记为 NonSerialized，
    ' 字段仍然还是被序列化了。

    Public PublicVariable As Integer
    Private privateVariable As Integer
    <NonSerialized()> Public NonSerializedVariable As Integer


    ' 要加载到字段的值中的简单构造函数。
    Public Sub New(ByVal argx As Integer, ByVal argy As Integer, ByVal argz As Integer)
        Me.PublicVariable = argx
        Me.privateVariable = argy
        Me.NonSerializedVariable = argz
    End Sub

    ''' <summary>
    ''' 这是在反序列化过程中调用的特殊构造函数。
    ''' 注意，字段和自定义信息（如时间戳）
    ''' 都可被序列化。
    ''' </summary>
    Public Sub New(ByVal info As SerializationInfo, ByVal context As StreamingContext)
        Me.PublicVariable = info.GetInt32("PublicVariable")
        Me.privateVariable = info.GetInt32("privateVariable")
        Me.NonSerializedVariable = info.GetInt32("NonSerializedVariable")
        Dim d As Date = info.GetDateTime("TimeStamp")
    End Sub

    Public ReadOnly Property PublicProperty() As Integer
        Get
            Return privateVariable
        End Get
    End Property

    Public Sub GetObjectData(ByVal info As SerializationInfo, ByVal context As StreamingContext) Implements ISerializable.GetObjectData
        With info
            .AddValue("PublicVariable", Me.PublicVariable)
            .AddValue("privateVariable", -1)
            .AddValue("NonSerializedVariable", Me.NonSerializedVariable)
            .AddValue("TimeStamp", Date.Now)
        End With
    End Sub
End Class